///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/HashKey.H"
#include "../../SharedSource/CRC32.H"

#include "Entry.H"
#include "Init.H"
#include "Routines.H"
#include "WinService.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[SENDBUFSZ + RECVBUFSZ];
    char sSendBuf[SENDBUFSZ + 1];
    char sTemp[SENDBUFSZ + RECVBUFSZ];

	int iCmdDataSz = 0;
	int iSendBufSz = 0;
	int iCmdFlagLength = 0;

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RawHash->")))
    {
		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Server requested key hash.", EVENT_NONE);
		}
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		HashKey((const unsigned char *)sCmdData, (unsigned char *)sCmdData, iCmdDataSz, iCmdDataSz);
		pSockSrvr->SetNextSendDataEx(iClient, sCmdData, iCmdDataSz);
		return AUTH_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestAuthString")))
    {
		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Server requested authentication.", EVENT_NONE);
		}

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI.SC.CipherEx(gsAuthString, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::AuthString->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewAuthKey->")))
    {
		char sNewAuthKey_Raw[MAX_KEY_LENGTH];

		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Server issued new cryptography key.", EVENT_NONE);
		}

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI.SC.CipherEx(sCmdData, sNewAuthKey_Raw, iCmdDataSz);
		sNewAuthKey_Raw[iCmdDataSz] = '\0';

		CCI.SC.DestroyCryptography();

		if(!CCI.SC.InitializeCryptographyEx(sNewAuthKey_Raw, iCmdDataSz, true))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to Initialize the cryptography set.", EVENT_ERROR);
		}

		CCI.SC.CipherEx(gsAuthString, sTemp, iTempLen);

		iSendBufSz = AppendDataToCmd("::NewKeyAuth->", sTemp, iTempLen, sSendBuf);

		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestVersion")))
    {
		int iTempLen = strlen(gsFileVersion);

		CCI.SC.CipherEx(gsFileVersion, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Version->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestCompanyName")))
    {
		int iTempLen = strlen(gsCompanyName);

		CCI.SC.CipherEx(gsCompanyName, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::CompanyName->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestPassword")))
    {
		int iTempLen = strlen(gsCompanyPassword);

		CCI.SC.CipherEx(gsCompanyPassword, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Password->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthenticationSuccess")))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication success.", EVENT_NONE);
		return AUTH_SUCCESS;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AutoUpdate->")))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Starting automatic update process.", EVENT_INFO);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

        char OldExe[MAX_PATH];
        char NewExe[MAX_PATH];

        sprintf_s(OldExe, sizeof(OldExe), "%s\\%s", gsPath, "AutoUpdate.Exe");
        sprintf_s(NewExe, sizeof(NewExe), "%s\\%s", Get_TempDirectory(), "SQLEUpdate.Exe");

        CopyFile(OldExe, NewExe, FALSE);
        ShellExecute(GetActiveWindow(), "Open", NewExe, sCmdData, Get_CurrentDirectory(), SW_SHOWNORMAL);
        CommandService(SERVICE_CONTROL_STOP);

		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
